\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 23))
  markup-system-spacing = #'((basic-distance . 16))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  %ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Ferice zi"
  subtitle = " "
  composer = "* * *"
  meter = "Andante"
  tagline=""
}

global = {
  \key g \major
  %\time 2/4
  %\partial 2
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Fe -- ri -- ce zi ce-am aş -- tep -- tat
  când din mor -- mân -- tu-n -- tu -- ne -- cat
  Hris -- tos din nou S-a a -- ră -- tat. __
  A -- li lu -- ia, a -- li lu -- ia,
  a -- li lu -- i -- a.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Dom -- nul cel Sfânt ni s-a i -- vit
  pre -- cum e cri -- nul în -- flo -- rit,
  și soa -- re -- le la ră -- să -- rit. __
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Şi, le -- gă -- nat pe-a -- ripi de vânt,
  s-a -- u -- de-un dul -- ce cân -- tec sfânt,
  cân -- tat de cer şi de pă -- mânt:
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  Hris -- tos din morţi a în -- vi -- at
  "cu moar" -- tea pe moar -- te a căl -- cat
  și via -- ţă tu -- tu -- ror ne-a dat! __  
}

menWordsOne = \lyricmode {
  \set stanza = "1."
  Fe -- ri -- ce zi ce-am aş -- tep -- tat,
  când, din mor -- mân -- tu-n -- tu -- ne -- cat,
  Hris -- tos din nou S-a a -- ră -- tat. __
  A -- li lu -- ia, a -- li lu -- i -- a.
}

menWords = \womenWordsOne

sopMusic = \relative c'' {
  g4 fis8 g a4 g fis e d2
  d4 e8 fis g4 e d c h2 
  h4 h8 c d4 d e e d( c)
  h4. c8 d4 d e4. fis8 g4 a
  h4( c d) c h a g2
  \bar "|."
}

altMusic = \relative c'' {
  g4 fis8 g a4 g fis e d2
  d4 e8 fis g4 e d c h2 
  h4 h8 c d4 d e e d( c)
  h4. c8 d4 d e4. c8 e4 d
  g4( a h4.) a8 g4 fis8([ a]) g2 
}

tenorMusic = \relative c' {
  g4 fis8 g a4 h c c h2
  h4 c8 h h4 c c c h2
  h4 h8 c h4 h c c h( c)
  %d4 d d d 
  d,1\rest
  c'4. d8 d4 d
  d4( c h4.) a8 g4 fis8([ a]) g2
}  

bassMusic = \relative c' {
  g4 fis8 e d4 d h c d2
  g4 fis8 e d4 d d c d2
  d4 d8 d d4 d e fis g2
  %g4 fis8( e) d4 d g4. e8 d4 d
  d1\rest d1\rest
  d2. d4 d d g2
  
}  

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      %\new Voice { \global \sopMusic }
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      \addlyrics { \womenWordsFour }
      \new Voice { \voiceTwo \global \altMusic }
    >>

    \new Staff <<
      \clef bass
      %\new Voice { \global \altMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWordsOne }
      \addlyrics { \womenWordsTwo }
      \addlyrics { \womenWordsThree }
      \addlyrics { \womenWordsFour }
      \new Voice { \voiceTwo \global \bassMusic }
    >>
  >>
>>

\score {
  \myScore
  %\layout { #(layout-set-staff-size 18) }
}

midiOutput = \midi {
    \tempo 4 = 80
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}